Attribute VB_Name = "MdlIniFile"
Option Explicit

Public Declare Function WritePrivateProfileString Lib "KERNEL32.DLL" Alias "WritePrivateProfileStringA" ( _
    ByVal lpAppName As String, _
    ByVal lpKeyName As Any, _
    ByVal lpString As Any, _
    ByVal lpFileName As String) As Long

Public Declare Function GetPrivateProfileString Lib "KERNEL32.DLL" Alias "GetPrivateProfileStringA" ( _
    ByVal lpAppName As String, _
    ByVal lpKeyName As Any, _
    ByVal lpDefault As String, _
    ByVal lpReturnedString As String, _
    ByVal nSize As Long, _
    ByVal lpFileName As String) As Long

Public Declare Function GetPrivateProfileInt Lib "KERNEL32.DLL" Alias "GetPrivateProfileIntA" ( _
    ByVal lpAppName As String, _
    ByVal lpKeyName As String, _
    ByVal nDefault As Long, _
    ByVal lpFileName As String) As Long
'
Public Declare Function PathRemoveFileSpec Lib "SHLWAPI.DLL" Alias "PathRemoveFileSpecA" ( _
    ByVal pszPath As String) As Long

Public Declare Function PathFindFileName Lib "SHLWAPI.DLL" Alias "PathFindFileNameA" ( _
    ByVal pszPath As String) As Long

Public Declare Sub MoveMemory Lib "kernel32" Alias "RtlMoveMemory" ( _
    pDest As Any, pSource As Any, ByVal ByteLen As Long)

Private Const MAX_PATH = 260
Private Const INI_FILE As String = ".\Analysis.ini"

Private Const APP_NAME_IP As String = "IP"
Private Const KEY_NAME_ADDR As String = "Address"
Private Const DEF_IP_ADDR As String = "127.0.0.1"

Private Const APP_NAME_DSPF As String = "DISP_FORMAT"
Private Const KEY_NAME_DSPF As String = "CH"

Private Const APP_NAME_OVRL As String = "DISP_OVERLAP"
Private Const KEY_NAME_OVRL As String = "CH"

Private Const APP_NAME_FDLG As String = "FileDialog"
Private Const KEY_NAME_FDLG As String = "Path"
Private Const KEY_NAME_XTAL As String = "XtalPath"

Private Const APP_NAME_BFDLG As String = "BmpFileDialog"
Private Const KEY_NAME_BFDLG As String = "Path"

Private Const APP_NAME_TRC_COLOR As String = "TraceColor"

Private Const KEY_NAME_LGMG As String = "LogMag"
Private Const KEY_NAME_GNLG As String = "LogMagGridN"
Private Const KEY_NAME_GBLG As String = "LogMagGridB"
Private Const KEY_NAME_M1LG As String = "Mem1_LogMag"
Private Const KEY_NAME_M2LG As String = "Mem2_LogMag"
Private Const KEY_NAME_M3LG As String = "Mem3_LogMag"
Private Const DEF_COLOR_LGMG As String = "&HFF, &HFF, &H00 "    '  vbYellow = &HFFFF
Private Const DEF_COLOR_GNLG As String = "&H2F, &H4F, &H4F "    '
Private Const DEF_COLOR_GBLG As String = "&H80, &H80, &H80 "    '
Private Const DEF_COLOR_M1LG As String = "&HFF, &H44, &H32 "    '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_M2LG As String = "&HFF, &H44, &H64 "    '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_M3LG As String = "&HFF, &H44, &H96 "    '  Trace Color Key word.(R,G,B)

Private Const KEY_NAME_PHSE As String = "Phase"
Private Const KEY_NAME_GNPH As String = "PhaseGridN"
Private Const KEY_NAME_GBPH As String = "PhaseGridB"
Private Const KEY_NAME_M1PH As String = "Mem1_Phase"
Private Const KEY_NAME_M2PH As String = "Mem2_Phase"
Private Const KEY_NAME_M3PH As String = "Mem3_Phase"
Private Const DEF_COLOR_PHASE As String = "&H00, &HFF, &H00 "   '  vbGreen = &HFF00
Private Const DEF_COLOR_M1PH As String = "&H00, &HC8, &H00 "    '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_M2PH As String = "&H00, &H96, &H00 "    '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_M3PH As String = "&H00, &H64, &H32 "    '  Trace Color Key word.(R,G,B)

Private Const KEY_NAME_POLA As String = "Polar"
Private Const KEY_NAME_GNPO As String = "PolarGridN"
Private Const KEY_NAME_GBPO As String = "PolarGridB"
Private Const KEY_NAME_M1PO As String = "Mem1_Polar"
Private Const KEY_NAME_M2PO As String = "Mem2_Polar"
Private Const KEY_NAME_M3PO As String = "Mem3_Polar"
Private Const DEF_COLOR_POLAR As String = "&HFA, &H80, &H72 "   '  Trace Color Key word.(R,G,B)
#If COLOR_INVERSE = 0 Then
Private Const DEF_COLOR_GNPO As String = "&HFF, &HFF, &HFF "    '
#Else
Private Const DEF_COLOR_GNPO As String = "&H80, &H80, &H80 "    '
#End If
Private Const DEF_COLOR_GBPO As String = DEF_COLOR_GNLG
Private Const DEF_COLOR_M1PO As String = "&HC8, &H80, &H72 "    '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_M2PO As String = "&H96, &H80, &H72 "    '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_M3PO As String = "&H64, &H80, &H72 "    '  Trace Color Key word.(R,G,B)

Private Const KEY_NAME_SMIT As String = "Smith"
Private Const KEY_NAME_GNSM As String = "SmithGridN"
Private Const KEY_NAME_GBSM As String = "SmithGridB"
Private Const KEY_NAME_M1SM As String = "Mem1_Smith"
Private Const KEY_NAME_M2SM As String = "Mem2_Smith"
Private Const KEY_NAME_M3SM As String = "Mem3_Smith"
Private Const DEF_COLOR_SMIT As String = "&H1E, &H90, &HFF "    '  Trace Color Key word.(R,G,B)
#If COLOR_INVERSE = 0 Then
Private Const DEF_COLOR_GNSM As String = "&HFF, &HFF, &HFF "    '
#Else
Private Const DEF_COLOR_GNSM As String = DEF_COLOR_GNLG         '
#End If
Private Const DEF_COLOR_GBSM As String = "&H80, &H80, &H80 "
Private Const DEF_COLOR_M1SM As String = "&H1E, &H90, &H96 "    '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_M2SM As String = "&H1E, &H90, &H64 "    '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_M3SM As String = "&H1E, &H90, &H32 "    '  Trace Color Key word.(R,G,B)

Private Const KEY_NAME_REAL As String = "Real"
Private Const KEY_NAME_GNRE As String = "RealGridN"
Private Const KEY_NAME_GBRE As String = "RealGridB"
Private Const KEY_NAME_M1RE As String = "Mem1_Real"
Private Const KEY_NAME_M2RE As String = "Mem2_Real"
Private Const KEY_NAME_M3RE As String = "Mem3_Real"
Private Const DEF_COLOR_REAL As String = "&H00, &HFF, &H7F "    '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_GNRE As String = DEF_COLOR_GNLG
Private Const DEF_COLOR_GBRE As String = DEF_COLOR_GBLG
Private Const DEF_COLOR_M1RE As String = "&H00, &HC8, &H7F "    '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_M2RE As String = "&H00, &H96, &H7F "    '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_M3RE As String = "&H00, &H64, &H7F "    '  Trace Color Key word.(R,G,B)

Private Const KEY_NAME_IMAG As String = "Imag"
Private Const KEY_NAME_GNIM As String = "ImagGridN"
Private Const KEY_NAME_GBIM As String = "ImagGridB"
Private Const KEY_NAME_M1IM As String = "Mem1_Imag"
Private Const KEY_NAME_M2IM As String = "Mem2_Imag"
Private Const KEY_NAME_M3IM As String = "Mem3_Imag"
Private Const DEF_COLOR_IMAG As String = "&H00, &HFF, &HFF "    '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_GNIM As String = DEF_COLOR_GNLG
Private Const DEF_COLOR_GBIM As String = DEF_COLOR_GBLG
Private Const DEF_COLOR_M1IM As String = "&H00, &HC8, &HFF "    '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_M2IM As String = "&H00, &H96, &HFF "    '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_M3IM As String = "&H00, &H64, &HFF "    '  Trace Color Key word.(R,G,B)

Private Const KEY_NAME_DELA As String = "Delay"
Private Const KEY_NAME_GNDE As String = "DelayGridN"
Private Const KEY_NAME_GBDE As String = "DelayGridB"
Private Const KEY_NAME_M1DE As String = "Mem1_Delay"
Private Const KEY_NAME_M2DE As String = "Mem2_Delay"
Private Const KEY_NAME_M3DE As String = "Mem3_Delay"
Private Const DEF_COLOR_DELA As String = "&HFF, &H14, &H93 "  '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_GNDE As String = DEF_COLOR_GNLG
Private Const DEF_COLOR_GBDE As String = DEF_COLOR_GBLG
Private Const DEF_COLOR_M1DE As String = "&HFF, &H14, &H64 "  '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_M2DE As String = "&HFF, &H14, &H32 "  '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_M3DE As String = "&HFF, &H14, &H00 "  '  Trace Color Key word.(R,G,B)

Private Const KEY_NAME__SWR As String = "Swr"
Private Const KEY_NAME_GNSW As String = "SwrGridN"
Private Const KEY_NAME_GBSW As String = "SwrGridB"
Private Const KEY_NAME_M1SW As String = "Mem1_Swr"
Private Const KEY_NAME_M2SW As String = "Mem2_Swr"
Private Const KEY_NAME_M3SW As String = "Mem3_Swr"
Private Const DEF_COLOR__SWR As String = "&HFF, &HA5, &H00 "    '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_GNSW As String = DEF_COLOR_GNLG
Private Const DEF_COLOR_GBSW As String = DEF_COLOR_GBLG
Private Const DEF_COLOR_M1SW As String = "&HFF, &H64, &H00 "    '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_M2SW As String = "&HFF, &H32, &H00 "    '  Trace Color Key word.(R,G,B)
Private Const DEF_COLOR_M3SW As String = "&HFF, &H00, &H00 "    '  Trace Color Key word.(R,G,B)

Private Const KEY_NAME_PICT As String = "PictBox"
#If COLOR_INVERSE = 0 Then
Private Const DEF_COLOR_PICT As String = "&H00, &H00, &H00 "    ' Black
#Else
Private Const DEF_COLOR_PICT As String = "&HFF, &HFF, &HFF "    ' White
#End If

Private Const APP_NAME_MKR_COLOR As String = "MarkerColor"

Private Const KEY_NAME_MKR_ACT As String = "MarkerAct"
Private Const KEY_NAME_MKR_NAC As String = "MarkerNotAct"
Private Const DEF_COLOR_MKR_ACT As String = "&HFF, &H00, &H00 "
Private Const DEF_COLOR_MKR_NAC As String = "&H00, &HFF, &HFF "

Private Const KEY_NAME_MKRL As String = "MarkerList"
Private Const KEY_NAME_MKRM As String = "MarkerMemList"
#If COLOR_INVERSE = 0 Then
Private Const DEF_COLOR_MKRL As String = "&HFF, &HFF, &HFF "    ' White
#Else
Private Const DEF_COLOR_MKRL As String = "&H00, &H00, &H00 "    ' Black
#End If

Private Const DEF_COLOR_MKRM As String = "&HFF, &H00, &H00 "

'********************************************
' Writes IP Address in Analysis.ini.
'********************************************
Public Sub WriteIniFile_IP_Adrs(ByVal Adrs As String)
    Dim ret As Long
    ret = WritePrivateProfileString(APP_NAME_IP, KEY_NAME_ADDR, Adrs, INI_FILE)
End Sub

'*********************************************
' Reads IP Address from Analysis.ini.
'*********************************************
Public Function ReadIniFile_IP_Adrs() As String
    Dim strSb As String
    Dim ret As Long
    
    strSb = "                "
    ret = GetPrivateProfileString(APP_NAME_IP, KEY_NAME_ADDR, DEF_IP_ADDR, strSb, Len(strSb), INI_FILE)
    ReadIniFile_IP_Adrs = strSb
End Function

'******************************************************
' Writes CH1 to CH4 formats in Analysis.ini.
' Ch_No :  1 - 6
' disp_format : 1:"Logmag", 2:"POLAR", 3:"Smith"
'               4:"DELAY",  5:"SWR",   6:"Overlap"
'******************************************************
Public Sub WriteIniFile_CH_Format(ByVal Ch_No As Integer, ByVal disp_format As Integer)
    Dim ret As Long
    
    ret = WritePrivateProfileString(APP_NAME_DSPF, KEY_NAME_DSPF & CStr(Ch_No), CStr(disp_format), INI_FILE)
End Sub

'********************************************************
' Reads CH1 to CH4 formats from Analysis.ini.
'********************************************************
Public Function ReadIniFile_CH_Format(ByVal Ch_No As Integer) As Integer
    ReadIniFile_CH_Format = GetPrivateProfileInt(APP_NAME_DSPF, KEY_NAME_DSPF & CStr(Ch_No), INI_FILE_RW_FORMAT_LOGAMG, INI_FILE)
End Function

'**********************************************************
' Writes CH1 to CH4 Display wave  formats in Analysis.ini.
' Ch_No :  1 - 4
' Overlap wave :MSB             LSB
'                +-+-+-+-+-+-+-+-+
'                +-+-+-+-+-+-+-+-+
'                         | | | +- bit0 :"Logmag"
'                         | | +--- bit1 :"POLAR"
'                         | | +--- bit3 :"Smith"
'                         | +----- bit4 :"DELAY"
'                         +------- bit5 :"SWR"
'
'**********************************************************
Public Sub WriteIniFile_CH_Overlap(ByVal Ch_No As Integer, ByVal ovrlap_wave As Integer)
    Dim ret As Long
    
    ret = WritePrivateProfileString(APP_NAME_OVRL, KEY_NAME_OVRL & CStr(Ch_No), CStr(ovrlap_wave), INI_FILE)
End Sub

'**********************************************************
' Reads CH1 to CH4 Display wave formats from Analysis.ini.
'**********************************************************
Public Function ReadIniFile_CH_Overlap(ByVal Ch_No As Integer) As Integer
    ReadIniFile_CH_Overlap = GetPrivateProfileInt(APP_NAME_OVRL, KEY_NAME_OVRL & CStr(Ch_No), _
                            INI_FILE_RW_OVRLAP_NOT_DISP, INI_FILE)
End Function

'************************************
'   Only API file name is taken out.
'************************************
Public Function FindFileName(ByVal strFileName As String) As String
    Dim strBuffer   As String
    Dim lngResult   As Long
    Dim bytStr()    As Byte

    lngResult = PathFindFileName(strFileName)
    If lngResult <> 0 Then
        ReDim bytStr(MAX_PATH + 1) As Byte
        MoveMemory bytStr(0), ByVal lngResult, MAX_PATH + 1
        strBuffer = StrConv(bytStr(), vbUnicode)
        FindFileName = Left$(strBuffer, InStr(strBuffer, vbNullChar) - 1)
    End If
End Function

'*****************************************
'   Only API file pathname is taken out.
'*****************************************
Public Function RemoveFileSpec(ByVal strPath As String) As String
    ' strPath : full path(path name and file name)
    ' return  : paht name

    Dim lngResult As Long
    lngResult = PathRemoveFileSpec(strPath)
    If lngResult <> 0 Then
        If 0 < InStr(strPath, vbNullChar) Then
            RemoveFileSpec = Left$(strPath, InStr(strPath, vbNullChar) - 1)
        Else
            RemoveFileSpec = strPath
        End If
    End If
End Function

'******************************************
' Writes File Dialog path in Analysis.ini.
'******************************************
Public Sub WriteIniFile_FileDlgPath(ByVal strFileDlgPath As String)
    Dim ret As Long
    ret = WritePrivateProfileString(APP_NAME_FDLG, KEY_NAME_FDLG, strFileDlgPath, INI_FILE)
End Sub

'******************************************
' Reads  File Dialog path in Analysis.ini.
'******************************************
Public Function ReadIniFile_FileDlgPath() As String
    Dim strPath As String
    Dim ret As Long
    
    strPath = App.path
    ret = GetPrivateProfileString(APP_NAME_FDLG, KEY_NAME_FDLG, strPath, strPath, Len(strPath), INI_FILE)
    ReadIniFile_FileDlgPath = strPath
End Function


'******************************************************
' Writes Bitmap Save File Dialog path in Analysis.ini.
'******************************************************
Public Sub WriteIniFile_BmpFileDlgPath(ByVal strFileDlgPath As String)
    Dim ret As Long
    ret = WritePrivateProfileString(APP_NAME_BFDLG, KEY_NAME_BFDLG, strFileDlgPath, INI_FILE)
End Sub

'*****************************************************
' Reads Bitmap Save File Dialog path in Analysis.ini.
'*****************************************************
Public Function ReadIniFile_BmpFileDlgPath() As String
    Dim strPath As String
    Dim ret As Long
    
    strPath = App.path
    ret = GetPrivateProfileString(APP_NAME_BFDLG, KEY_NAME_BFDLG, strPath, strPath, Len(strPath), INI_FILE)
    ReadIniFile_BmpFileDlgPath = strPath
End Function

'*******************************************************************
' Writes tuning fork crystal unit File Dialog path in Analysis.ini.
'*******************************************************************
Public Sub WriteIniFile_FileDlgPathXtal(ByVal strFileDlgPath As String)
    Dim ret As Long
    ret = WritePrivateProfileString(APP_NAME_FDLG, KEY_NAME_XTAL, strFileDlgPath, INI_FILE)
End Sub

'*******************************************************************
' Reads tuning fork crystal unit File Dialog path in Analysis.ini.
'*******************************************************************
Public Function ReadIniFile_FileDlgPathXtal() As String
    Dim strPath As String
    Dim ret As Long
    
    strPath = App.path
    ret = GetPrivateProfileString(APP_NAME_FDLG, KEY_NAME_XTAL, strPath, strPath, Len(strPath), INI_FILE)
    ReadIniFile_FileDlgPathXtal = strPath
End Function


'*******************************************************
' The PictBox color of is write to a Analysis.ini file.
'*******************************************************
Public Sub WriteIniPictBoxColor(ByVal lngColor As Long)
    Dim strColor As String * 32
    Dim ret As Long
    
    strColor = "&H" & Hex(lngColor And 255) & ", &H" & Hex((lngColor And 65280) / &H100) & ", &H" & Hex((lngColor And 16711680) / &H10000) & ", "
    ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_PICT, strColor, INI_FILE)
End Sub

'*****************************************************
' The PictBox color is read from a Analysis.ini file.
'*****************************************************
Public Function ReadIniPictBoxColor(ByRef strColor As String) As Long
    Dim aryTemp As Variant
    Dim ret As Long
    
    strColor = DEF_COLOR_PICT
    ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_PICT, strColor, strColor, Len(strColor), INI_FILE)
    aryTemp = Split(strColor, ",")
    ReadIniPictBoxColor = CLng(aryTemp(2) * &H10000 + aryTemp(1) * &H100 + aryTemp(0))
End Function


'*******************************************************************************************
' The LogMag color of active trace or grid or memory trace is write to a Analysis.ini file.
'*******************************************************************************************
Public Sub WriteIniLogMagTraceColor(ByVal GetTraceColor As Integer, ByVal lngColor As Long)
    Dim strColor As String * 32
    Dim ret As Long
    
    strColor = "&H" & Hex(lngColor And 255) & ", &H" & Hex((lngColor And 65280) / &H100) & ", &H" & Hex((lngColor And 16711680) / &H10000) & ", "
    
    Select Case GetTraceColor
        Case TRACE_COLOR__ACT:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_LGMG, strColor, INI_FILE)
        Case TRACE_COLOR_GRDN:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GNLG, strColor, INI_FILE)
        Case TRACE_COLOR_GRDB:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GBLG, strColor, INI_FILE)
        Case TRACE_COLOR_MEM1:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M1LG, strColor, INI_FILE)
        Case TRACE_COLOR_MEM2:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M2LG, strColor, INI_FILE)
        Case TRACE_COLOR_MEM3:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M3LG, strColor, INI_FILE)
    End Select
End Sub

'*******************************************************************************************
' The LogMag color of active trace or grid or memory trace is read from a Analysis.ini file.
'*******************************************************************************************
Public Function ReadIniLogMagTraceColor(ByVal GetTraceColor As Integer, ByRef strColor As String) As Long
    Dim aryTemp As Variant
    Dim ret As Long
    
    Select Case GetTraceColor
        Case TRACE_COLOR__ACT:
            strColor = DEF_COLOR_LGMG
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_LGMG, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_GRDN:
            strColor = DEF_COLOR_GNLG
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GNLG, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_GRDB:
            strColor = DEF_COLOR_GBLG
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GBLG, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM1:
            strColor = DEF_COLOR_M1LG
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M1LG, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM2:
            strColor = DEF_COLOR_M2LG
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M2LG, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM3:
            strColor = DEF_COLOR_M3LG
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M3LG, strColor, strColor, Len(strColor), INI_FILE)
    End Select
    aryTemp = Split(strColor, ",")
    ReadIniLogMagTraceColor = CLng(aryTemp(2) * &H10000 + aryTemp(1) * &H100 + aryTemp(0))
End Function


'*******************************************************************************************
' The Phase color of active trace or grid or memory trace is write to a Analysis.ini file.
'*******************************************************************************************
Public Sub WriteIniPhaseTraceColor(ByVal GetTraceColor As Integer, ByVal lngColor As Long)
    Dim strColor As String * 32
    Dim ret As Long
    
    strColor = "&H" & Hex(lngColor And 255) & ", &H" & Hex((lngColor And 65280) / &H100) & ", &H" & Hex((lngColor And 16711680) / &H10000) & ", "
    
    Select Case GetTraceColor
        Case TRACE_COLOR__ACT:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_PHSE, strColor, INI_FILE)
        Case TRACE_COLOR_GRDN:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GNPH, strColor, INI_FILE)
        Case TRACE_COLOR_GRDB:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GBPH, strColor, INI_FILE)
        Case TRACE_COLOR_MEM1:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M1PH, strColor, INI_FILE)
        Case TRACE_COLOR_MEM2:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M2PH, strColor, INI_FILE)
        Case TRACE_COLOR_MEM3:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M3PH, strColor, INI_FILE)
    End Select
End Sub

'*******************************************************************************************
' The Phase color of active trace or grid or memory trace is read from a Analysis.ini file.
'*******************************************************************************************
Public Function ReadIniPhaseTraceColor(ByVal GetTraceColor As Integer, ByRef strColor As String) As Long
    Dim aryTemp As Variant
    Dim ret As Long
    
    Select Case GetTraceColor
        Case TRACE_COLOR__ACT:
            strColor = DEF_COLOR_PHASE
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_PHSE, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM1:
            strColor = DEF_COLOR_M1PH
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M1PH, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM2:
            strColor = DEF_COLOR_M2PH
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M2PH, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM3:
            strColor = DEF_COLOR_M3PH
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M3PH, strColor, strColor, Len(strColor), INI_FILE)
    End Select
    aryTemp = Split(strColor, ",")
    ReadIniPhaseTraceColor = CLng(aryTemp(2) * &H10000 + aryTemp(1) * &H100 + aryTemp(0))
End Function


'*******************************************************************************************
' The Polar color of active trace or grid or memory trace is write to a Analysis.ini file.
'*******************************************************************************************
Public Sub WriteIniPolarTraceColor(ByVal GetTraceColor As Integer, ByVal lngColor As Long)
    Dim strColor As String * 32
    Dim ret As Long
    
    strColor = "&H" & Hex(lngColor And 255) & ", &H" & Hex((lngColor And 65280) / &H100) & ", &H" & Hex((lngColor And 16711680) / &H10000) & ", "
    
    Select Case GetTraceColor
        Case TRACE_COLOR__ACT:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_POLA, strColor, INI_FILE)
        Case TRACE_COLOR_GRDN:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GNPO, strColor, INI_FILE)
        Case TRACE_COLOR_GRDB:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GBPO, strColor, INI_FILE)
        Case TRACE_COLOR_MEM1:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M1PO, strColor, INI_FILE)
        Case TRACE_COLOR_MEM2:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M2PO, strColor, INI_FILE)
        Case TRACE_COLOR_MEM3:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M3PO, strColor, INI_FILE)
    End Select
End Sub

'*******************************************************************************************
' The Polar color of active trace or grid or memory trace is read from a Analysis.ini file.
'*******************************************************************************************
Public Function ReadIniPolarTraceColor(ByVal GetTraceColor As Integer, ByRef strColor As String) As Long
    Dim aryTemp As Variant
    Dim ret As Long
    
    Select Case GetTraceColor
        Case TRACE_COLOR__ACT:
            strColor = DEF_COLOR_POLAR
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_POLA, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_GRDN:
            strColor = DEF_COLOR_GNPO
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GNPO, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_GRDB:
            strColor = DEF_COLOR_GBPO
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GBPO, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM1:
            strColor = DEF_COLOR_M1PO
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M1PO, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM2:
            strColor = DEF_COLOR_M2PO
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M2PO, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM3:
            strColor = DEF_COLOR_M3PO
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M3PO, strColor, strColor, Len(strColor), INI_FILE)
    End Select
    aryTemp = Split(strColor, ",")
    ReadIniPolarTraceColor = CLng(aryTemp(2) * &H10000 + aryTemp(1) * &H100 + aryTemp(0))
End Function


'*******************************************************************************************
' The Smith color of active trace or grid or memory trace is write to a Analysis.ini file.
'*******************************************************************************************
Public Sub WriteIniSmithTraceColor(ByVal GetTraceColor As Integer, ByVal lngColor As Long)
    Dim strColor As String * 32
    Dim ret As Long
    
    strColor = "&H" & Hex(lngColor And 255) & ", &H" & Hex((lngColor And 65280) / &H100) & ", &H" & Hex((lngColor And 16711680) / &H10000) & ", "
    
    Select Case GetTraceColor
        Case TRACE_COLOR__ACT:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_SMIT, strColor, INI_FILE)
        Case TRACE_COLOR_GRDN:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GNSM, strColor, INI_FILE)
        Case TRACE_COLOR_GRDB:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GBSM, strColor, INI_FILE)
        Case TRACE_COLOR_MEM1:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M1SM, strColor, INI_FILE)
        Case TRACE_COLOR_MEM2:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M2SM, strColor, INI_FILE)
        Case TRACE_COLOR_MEM3:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M3SM, strColor, INI_FILE)
    End Select
End Sub

'*******************************************************************************************
' The Smith color of active trace or grid or memory trace is read from a Analysis.ini file.
'*******************************************************************************************
Public Function ReadIniSmithTraceColor(ByVal GetTraceColor As Integer, ByRef strColor As String) As Long
    Dim aryTemp As Variant
    Dim ret As Long
    
    Select Case GetTraceColor
        Case TRACE_COLOR__ACT:
            strColor = DEF_COLOR_SMIT
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_SMIT, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_GRDN:
            strColor = DEF_COLOR_GNSM
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GNSM, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_GRDB:
            strColor = DEF_COLOR_GBSM
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GBSM, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM1:
            strColor = DEF_COLOR_M1SM
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M1SM, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM2:
            strColor = DEF_COLOR_M2SM
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M2SM, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM3:
            strColor = DEF_COLOR_M3SM
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M3SM, strColor, strColor, Len(strColor), INI_FILE)
    End Select
    aryTemp = Split(strColor, ",")
    ReadIniSmithTraceColor = CLng(aryTemp(2) * &H10000 + aryTemp(1) * &H100 + aryTemp(0))
End Function

'*******************************************************************************************
' The Real color of active trace or grid or memory trace is write to a Analysis.ini file.
'*******************************************************************************************
Public Sub WriteIniRealTraceColor(ByVal GetTraceColor As Integer, ByVal lngColor As Long)
    Dim strColor As String * 32
    Dim ret As Long
    
    strColor = "&H" & Hex(lngColor And 255) & ", &H" & Hex((lngColor And 65280) / &H100) & ", &H" & Hex((lngColor And 16711680) / &H10000) & ", "
    
    Select Case GetTraceColor
        Case TRACE_COLOR__ACT:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_REAL, strColor, INI_FILE)
        Case TRACE_COLOR_GRDN:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GNRE, strColor, INI_FILE)
        Case TRACE_COLOR_GRDB:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GBRE, strColor, INI_FILE)
        Case TRACE_COLOR_MEM1:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M1RE, strColor, INI_FILE)
        Case TRACE_COLOR_MEM2:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M2RE, strColor, INI_FILE)
        Case TRACE_COLOR_MEM3:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M3RE, strColor, INI_FILE)
    End Select
End Sub

'*******************************************************************************************
' The Real color of active trace or grid or memory trace is read from a Analysis.ini file.
'*******************************************************************************************
Public Function ReadIniRealTraceColor(ByVal GetTraceColor As Integer, ByRef strColor As String) As Long
    Dim aryTemp As Variant
    Dim ret As Long
    
    Select Case GetTraceColor
        Case TRACE_COLOR__ACT:
            strColor = DEF_COLOR_REAL
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_REAL, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_GRDN:
            strColor = DEF_COLOR_GNRE
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GNRE, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_GRDB:
            strColor = DEF_COLOR_GBRE
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GBRE, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM1:
            strColor = DEF_COLOR_M1RE
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M1RE, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM2:
            strColor = DEF_COLOR_M2RE
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M2RE, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM3:
            strColor = DEF_COLOR_M3RE
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M3RE, strColor, strColor, Len(strColor), INI_FILE)
    End Select
    aryTemp = Split(strColor, ",")
    ReadIniRealTraceColor = CLng(aryTemp(2) * &H10000 + aryTemp(1) * &H100 + aryTemp(0))
End Function


'*******************************************************************************************
' The Imag color of active trace or grid or memory trace is write to a Analysis.ini file.
'*******************************************************************************************
Public Sub WriteIniImagTraceColor(ByVal GetTraceColor As Integer, ByVal lngColor As Long)
    Dim strColor As String * 32
    Dim ret As Long
    
    strColor = "&H" & Hex(lngColor And 255) & ", &H" & Hex((lngColor And 65280) / &H100) & ", &H" & Hex((lngColor And 16711680) / &H10000) & ", "
    
    Select Case GetTraceColor
        Case TRACE_COLOR__ACT:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_IMAG, strColor, INI_FILE)
        Case TRACE_COLOR_GRDN:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GNIM, strColor, INI_FILE)
        Case TRACE_COLOR_GRDB:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GBIM, strColor, INI_FILE)
        Case TRACE_COLOR_MEM1:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M1IM, strColor, INI_FILE)
        Case TRACE_COLOR_MEM2:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M2IM, strColor, INI_FILE)
        Case TRACE_COLOR_MEM3:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M3IM, strColor, INI_FILE)
    End Select
End Sub

'*******************************************************************************************
' The Imag color of active trace or grid or memory trace is read from a Analysis.ini file.
'*******************************************************************************************
Public Function ReadIniImagTraceColor(ByVal GetTraceColor As Integer, ByRef strColor As String) As Long
    Dim aryTemp As Variant
    Dim ret As Long
    
    Select Case GetTraceColor
        Case TRACE_COLOR__ACT:
            strColor = DEF_COLOR_IMAG
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_IMAG, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_GRDN:
            strColor = DEF_COLOR_GNIM
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GNIM, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_GRDB:
            strColor = DEF_COLOR_GBIM
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GBIM, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM1:
            strColor = DEF_COLOR_M1IM
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M1IM, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM2:
            strColor = DEF_COLOR_M2IM
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M1IM, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM3:
            strColor = DEF_COLOR_M3IM
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M1IM, strColor, strColor, Len(strColor), INI_FILE)
    End Select
    aryTemp = Split(strColor, ",")
    ReadIniImagTraceColor = CLng(aryTemp(2) * &H10000 + aryTemp(1) * &H100 + aryTemp(0))
End Function


'*******************************************************************************************
' The Delay color of active trace or grid or memory trace is write to a Analysis.ini file.
'*******************************************************************************************
Public Sub WriteIniDelayTraceColor(ByVal GetTraceColor As Integer, ByVal lngColor As Long)
    Dim strColor As String * 32
    Dim ret As Long
    
    strColor = "&H" & Hex(lngColor And 255) & ", &H" & Hex((lngColor And 65280) / &H100) & ", &H" & Hex((lngColor And 16711680) / &H10000) & ", "
    
    Select Case GetTraceColor
        Case TRACE_COLOR__ACT:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_DELA, strColor, INI_FILE)
        Case TRACE_COLOR_GRDN:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GNDE, strColor, INI_FILE)
        Case TRACE_COLOR_GRDB:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GBDE, strColor, INI_FILE)
        Case TRACE_COLOR_MEM1:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M1DE, strColor, INI_FILE)
        Case TRACE_COLOR_MEM2:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M2DE, strColor, INI_FILE)
        Case TRACE_COLOR_MEM3:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M3DE, strColor, INI_FILE)
    End Select
End Sub

'*******************************************************************************************
' The Delay color of active trace or grid or memory trace is read from a Analysis.ini file.
'*******************************************************************************************
Public Function ReadIniDelayTraceColor(ByVal GetTraceColor As Integer, ByRef strColor As String) As Long
    Dim aryTemp As Variant
    Dim ret As Long
    
    Select Case GetTraceColor
        Case TRACE_COLOR__ACT:
            strColor = DEF_COLOR_DELA
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_DELA, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_GRDN:
            strColor = DEF_COLOR_GNDE
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GNDE, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_GRDB:
            strColor = DEF_COLOR_GBDE
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GBDE, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM1:
            strColor = DEF_COLOR_M1DE
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M1DE, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM2:
            strColor = DEF_COLOR_M2DE
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M2DE, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM3:
            strColor = DEF_COLOR_M3DE
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M3DE, strColor, strColor, Len(strColor), INI_FILE)
    End Select
    aryTemp = Split(strColor, ",")
    ReadIniDelayTraceColor = CLng(aryTemp(2) * &H10000 + aryTemp(1) * &H100 + aryTemp(0))
End Function

'*******************************************************************************************
' The Swr color of active trace or grid or memory trace is write to a Analysis.ini file.
'*******************************************************************************************
Public Sub WriteIniSwrTraceColor(ByVal GetTraceColor As Integer, ByVal lngColor As Long)
    Dim strColor As String * 32
    Dim ret As Integer
    
    strColor = "&H" & Hex(lngColor And 255) & ", &H" & Hex((lngColor And 65280) / &H100) & ", &H" & Hex((lngColor And 16711680) / &H10000) & ", "
    
    Select Case GetTraceColor
        Case TRACE_COLOR__ACT:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME__SWR, strColor, INI_FILE)
        Case TRACE_COLOR_GRDN:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GNSW, strColor, INI_FILE)
        Case TRACE_COLOR_GRDB:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GBSW, strColor, INI_FILE)
        Case TRACE_COLOR_MEM1:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M1SW, strColor, INI_FILE)
        Case TRACE_COLOR_MEM2:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M2SW, strColor, INI_FILE)
        Case TRACE_COLOR_MEM3:
            ret = WritePrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M3SW, strColor, INI_FILE)
    End Select
End Sub

'*******************************************************************************************
' The Swr color of active trace or grid or memory trace is read from a Analysis.ini file.
'*******************************************************************************************
Public Function ReadIniSwrTraceColor(ByVal GetTraceColor As Integer, ByRef strColor As String) As Long
    Dim aryTemp As Variant
    Dim ret As Long
    
    Select Case GetTraceColor
        Case TRACE_COLOR__ACT:
            strColor = DEF_COLOR__SWR
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME__SWR, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_GRDN:
            strColor = DEF_COLOR_GNSW
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GNSW, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_GRDB:
            strColor = DEF_COLOR_GBSW
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_GBSW, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM1:
            strColor = DEF_COLOR_M1SW
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M1SW, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM2:
            strColor = DEF_COLOR_M2SW
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M2SW, strColor, strColor, Len(strColor), INI_FILE)
        Case TRACE_COLOR_MEM3:
            strColor = DEF_COLOR_M3SW
            ret = GetPrivateProfileString(APP_NAME_TRC_COLOR, KEY_NAME_M3SW, strColor, strColor, Len(strColor), INI_FILE)
    End Select
    aryTemp = Split(strColor, ",")
    ReadIniSwrTraceColor = CLng(aryTemp(2) * &H10000 + aryTemp(1) * &H100 + aryTemp(0))
End Function


'********************************************************
' The Marker color is write to a Analysis.ini file.
'********************************************************
Public Sub WriteIniMkrColor(ByVal GetMkrColor As Integer, ByVal lngColor As Long)
    Dim strColor As String * 32
    Dim ret As Long
    
    strColor = "&H" & Hex(lngColor And 255) & ", &H" & Hex((lngColor And 65280) / &H100) & ", &H" & Hex((lngColor And 16711680) / &H10000) & ", "
    
    Select Case GetMkrColor
        Case MKR_COLOR___ACT:
            ret = WritePrivateProfileString(APP_NAME_MKR_COLOR, KEY_NAME_MKR_ACT, strColor, INI_FILE)
        Case MKR_COLOR_NOACT:
            ret = WritePrivateProfileString(APP_NAME_MKR_COLOR, KEY_NAME_MKR_NAC, strColor, INI_FILE)
    End Select
    
End Sub

'********************************************************
' The Marker color is read from a Analysis.ini file.
'********************************************************
Public Function ReadIniLogMkrColor(ByVal GetMkrColor As Integer, ByRef strColor As String) As Long
    Dim aryTemp As Variant
    Dim ret As Long
    
    Select Case GetMkrColor
        Case MKR_COLOR___ACT:
            strColor = DEF_COLOR_MKR_ACT
            ret = GetPrivateProfileString(APP_NAME_MKR_COLOR, KEY_NAME_MKR_ACT, strColor, strColor, Len(strColor), INI_FILE)
        Case MKR_COLOR_NOACT:
            strColor = DEF_COLOR_MKR_NAC
            ret = GetPrivateProfileString(APP_NAME_MKR_COLOR, KEY_NAME_MKR_NAC, strColor, strColor, Len(strColor), INI_FILE)
    End Select
    
    aryTemp = Split(strColor, ",")
    ReadIniLogMkrColor = CLng(aryTemp(2) * &H10000 + aryTemp(1) * &H100 + aryTemp(0))
End Function


'********************************************************
' The Marker List color is write to a Analysis.ini file.
'********************************************************
Public Sub WriteIniMkrListColor(ByVal GetMkrColor As Integer, ByVal lngColor As Long)
    Dim strColor As String * 32
    Dim ret As Long
    
    strColor = "&H" & Hex(lngColor And 255) & ", &H" & Hex((lngColor And 65280) / &H100) & ", &H" & Hex((lngColor And 16711680) / &H10000) & ", "
    
    Select Case GetMkrColor
        Case MKR_L_COLOR_ACT:
            ret = WritePrivateProfileString(APP_NAME_MKR_COLOR, KEY_NAME_MKRL, strColor, INI_FILE)
        Case MKR_L_COLOR_MEM:
            ret = WritePrivateProfileString(APP_NAME_MKR_COLOR, KEY_NAME_MKRM, strColor, INI_FILE)
    End Select
    
End Sub

'********************************************************
' The Marker List color is read from a Analysis.ini file.
'********************************************************
Public Function ReadIniMkrListColor(ByVal GetMkrColor As Integer, ByRef strColor As String) As Long
    Dim aryTemp As Variant
    Dim ret As Long
    
    Select Case GetMkrColor
        Case MKR_L_COLOR_ACT:
            strColor = DEF_COLOR_MKRL
            ret = GetPrivateProfileString(APP_NAME_MKR_COLOR, KEY_NAME_MKRL, strColor, strColor, Len(strColor), INI_FILE)
        Case MKR_L_COLOR_MEM:
            strColor = DEF_COLOR_MKRM
            ret = GetPrivateProfileString(APP_NAME_MKR_COLOR, KEY_NAME_MKRM, strColor, strColor, Len(strColor), INI_FILE)
    End Select
    
    aryTemp = Split(strColor, ",")
    ReadIniMkrListColor = CLng(aryTemp(2) * &H10000 + aryTemp(1) * &H100 + aryTemp(0))
End Function

''*******************************************************************
'' Writes tuning fork crystal unit Nominal frequency in Analysis.ini.
''*******************************************************************
'Public Sub WriteIniFile_XtalNominalFreq(ByVal strFreq As String)
'    Dim ret As Long
'    ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FREQ, strFreq, INI_FILE)
'End Sub
'
''*******************************************************************
'' Reads tuning fork crystal unit Nominal frequency in Analysis.ini.
''*******************************************************************
'Public Function ReadIniFile_XtalNominalFreq() As String
'    Dim strFreq As String
'    Dim ret As Long
'
'    strFreq = "                "
'    ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FREQ, DEF_XTAL_FREQ, strFreq, Len(strFreq), INI_FILE)
'    ReadIniFile_XtalNominalFreq = strFreq
'End Function
'
''*******************************************************************
'' Writes tuning fork crystal unit Load capacitance in Analysis.ini.
''*******************************************************************
'Public Sub WriteIniFile_XtalLoadCap(ByVal strCap As String)
'    Dim ret As Long
'    ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CAP, strCap, INI_FILE)
'End Sub
'
''*******************************************************************
'' Reads tuning fork crystal unit Load capacitance in Analysis.ini.
''*******************************************************************
'Public Function ReadIniFile_XtalLoadCap() As String
'    Dim strCap As String
'    Dim ret As Long
'
'    strCap = "                "
'    ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CAP, DEF_XTAL_CAP, strCap, Len(strCap), INI_FILE)
'    ReadIniFile_XtalLoadCap = strCap
'End Function
'
''*********************************************************
'' Writes tuning fork crystal unit Typ.CI in Analysis.ini.
''*********************************************************
'Public Sub WriteIniFile_XtalTypCI(ByVal strCI As String)
'    Dim ret As Long
'    ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CI, strCI, INI_FILE)
'End Sub
'
''********************************************************
'' Reads tuning fork crystal unit Typ.CI in Analysis.ini.
''********************************************************
'Public Function ReadIniFile_XtalTypCI() As String
'    Dim strCI As String
'    Dim ret As Long
'
'    strCI = "                "
'    ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CI, DEF_XTAL_CI, strCI, Len(strCI), INI_FILE)
'    ReadIniFile_XtalTypCI = strCI
'End Function
'
''******************************************************************
'' Writes tuning fork crystal unit C0 / other / FL in Analysis.ini.
''******************************************************************
'Public Sub WriteIniFile_XtalIni(ByVal idx As Integer, ByVal strRtn As String)
'    Dim ret As Long
'
'' Center Freq
'    If idx = DEV_C0C_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0FRQ, strRtn, INI_FILE)
'    ElseIf idx = DEV_OTC_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTFRQ, strRtn, INI_FILE)
'    ElseIf idx = DEV_FLC_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLFRQ, strRtn, INI_FILE)
'    ElseIf idx = DEV_CAC_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CAFRQ, strRtn, INI_FILE)
'' Span
'    ElseIf idx = DEV_C0S_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0SPN, strRtn, INI_FILE)
'    ElseIf idx = DEV_OTS_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTSPN, strRtn, INI_FILE)
'    ElseIf idx = DEV_FLS_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLSPN, strRtn, INI_FILE)
'    ElseIf idx = DEV_CAS_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CASPN, strRtn, INI_FILE)
'' Points
'    ElseIf idx = DEV_C0P_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0PNT, strRtn, INI_FILE)
'    ElseIf idx = DEV_OTP_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTPNT, strRtn, INI_FILE)
'    ElseIf idx = DEV_FLP_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLPNT, strRtn, INI_FILE)
'    ElseIf idx = DEV_CAP_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CAPNT, strRtn, INI_FILE)
'' Level of drive
'    ElseIf idx = DEV_C0L_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0LVL, strRtn, INI_FILE)
'    ElseIf idx = DEV_OTL_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTLVL, strRtn, INI_FILE)
'    ElseIf idx = DEV_FLL_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLLVL, strRtn, INI_FILE)
'    ElseIf idx = DEV_CAL_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CALVL, strRtn, INI_FILE)
'' RBW
'    ElseIf idx = DEV_C0R_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0RBW, strRtn, INI_FILE)
'    ElseIf idx = DEV_OTR_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTRBW, strRtn, INI_FILE)
'    ElseIf idx = DEV_FLR_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLRBW, strRtn, INI_FILE)
'    ElseIf idx = DEV_CAR_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CARBW, strRtn, INI_FILE)
'' Settling Time
'    ElseIf idx = DEV_C0T_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0TIM, strRtn, INI_FILE)
'    ElseIf idx = DEV_OTT_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTTIM, strRtn, INI_FILE)
'    ElseIf idx = DEV_FLT_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLTIM, strRtn, INI_FILE)
'    ElseIf idx = DEV_CAT_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CATIM, strRtn, INI_FILE)
'    End If
'
'End Sub
'
''*****************************************************************
'' Reads tuning fork crystal unit C0 / other / FL in Analysis.ini.
''*****************************************************************
'Public Function ReadIniFile_XtalIni(ByVal idx As Integer) As String
'    Dim strRtn As String
'    Dim ret As Long
'
'    strRtn = "                           "
'
'' Center Freq
'    If idx = DEV_C0C_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0FRQ, DEF_XTAL_C0FRQ, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_OTC_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTFRQ, DEF_XTAL_OTFRQ, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_FLC_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLFRQ, DEF_XTAL_FLFRQ, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_CAC_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CAFRQ, DEF_XTAL_CAFRQ, strRtn, Len(strRtn), INI_FILE)
'' Span
'    ElseIf idx = DEV_C0S_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0SPN, DEF_XTAL_C0SPN, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_OTS_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTSPN, DEF_XTAL_OTSPN, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_FLS_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLSPN, DEF_XTAL_FLSPN, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_CAS_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CASPN, DEF_XTAL_CASPN, strRtn, Len(strRtn), INI_FILE)
'' Points
'    ElseIf idx = DEV_C0P_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0PNT, DEF_XTAL_C0PNT, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_OTP_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTPNT, DEF_XTAL_OTPNT, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_FLP_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLPNT, DEF_XTAL_FLPNT, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_CAP_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CAPNT, DEF_XTAL_CAPNT, strRtn, Len(strRtn), INI_FILE)
'' Level of drive
'    ElseIf idx = DEV_C0L_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0LVL, DEF_XTAL_C0LVL, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_OTL_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTLVL, DEF_XTAL_OTLVL, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_FLL_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLLVL, DEF_XTAL_FLLVL, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_CAL_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CALVL, DEF_XTAL_CALVL, strRtn, Len(strRtn), INI_FILE)
'' RBW
'    ElseIf idx = DEV_C0R_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0RBW, DEF_XTAL_C0RBW, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_OTR_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTRBW, DEF_XTAL_OTRBW, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_FLR_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLRBW, DEF_XTAL_FLRBW, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_CAR_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CARBW, DEF_XTAL_CARBW, strRtn, Len(strRtn), INI_FILE)
'' Settling Time
'    ElseIf idx = DEV_C0T_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_C0TIM, DEF_XTAL_C0TIM, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_OTT_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OTTIM, DEF_XTAL_OTTIM, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_FLT_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_FLTIM, DEF_XTAL_FLTIM, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_CAT_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_CATIM, DEF_XTAL_CATIM, strRtn, Len(strRtn), INI_FILE)
'    End If
'
'    ReadIniFile_XtalIni = strRtn
'End Function
'
''******************************************************************
'' Writes tuning fork crystal Calibration Kit in Analysis.ini.
''******************************************************************
'Public Sub WriteIniFile_XtalCal(ByVal idx As Integer, ByVal strRtn As String)
'    Dim ret As Long
'
'' OPEN
'    If idx = DEV_ORS_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OPN_R, strRtn, INI_FILE)
'    ElseIf idx = DEV_OLS_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OPN_L, strRtn, INI_FILE)
'    ElseIf idx = DEV_OCP_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OPN_C, strRtn, INI_FILE)
'' SHORT
'    ElseIf idx = DEV_SRS_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_SHT_R, strRtn, INI_FILE)
'    ElseIf idx = DEV_SLS_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_SHT_L, strRtn, INI_FILE)
'    ElseIf idx = DEV_SCP_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_SHT_C, strRtn, INI_FILE)
'' LOAD
'    ElseIf idx = DEV_LRS_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_LOD_R, strRtn, INI_FILE)
'    ElseIf idx = DEV_LLS_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_LOD_L, strRtn, INI_FILE)
'    ElseIf idx = DEV_LCP_Index Then
'        ret = WritePrivateProfileString(APP_NAME_XTAL, KEY_XTAL_LOD_C, strRtn, INI_FILE)
'    End If
'
'End Sub
'
''*****************************************************************
'' Reads tuning fork crystal unit Calibration Kit in Analysis.ini.
''*****************************************************************
'Public Function ReadIniFile_XtalCal(ByVal idx As Integer) As String
'    Dim strRtn As String
'    Dim ret As Long
'
'    strRtn = "                           "
'
'' OPEN
'    If idx = DEV_ORS_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OPN_R, DEF_XTAL_OPN_R, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_OLS_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OPN_L, DEF_XTAL_OPN_L, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_OCP_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_OPN_C, DEF_XTAL_OPN_C, strRtn, Len(strRtn), INI_FILE)
'' SHORT
'    ElseIf idx = DEV_SRS_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_SHT_R, DEF_XTAL_SHT_R, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_SLS_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_SHT_L, DEF_XTAL_SHT_L, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_SCP_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_SHT_C, DEF_XTAL_SHT_C, strRtn, Len(strRtn), INI_FILE)
'' LOAD
'    ElseIf idx = DEV_LRS_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_LOD_R, DEF_XTAL_LOD_R, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_LLS_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_LOD_L, DEF_XTAL_LOD_L, strRtn, Len(strRtn), INI_FILE)
'    ElseIf idx = DEV_LCP_Index Then
'        ret = GetPrivateProfileString(APP_NAME_XTAL, KEY_XTAL_LOD_C, DEF_XTAL_LOD_C, strRtn, Len(strRtn), INI_FILE)
'    End If
'
'    ReadIniFile_XtalCal = strRtn
'End Function


